/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.mayor;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.ITraderStatus;
import dev.toma.gunsrpg.common.capability.object.PlayerTraderStandings;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.common.quests.mayor.ReputationStatus;
import dev.toma.gunsrpg.util.helper.ReputationHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.INBTSerializable;

public class TraderStatus
implements ITraderStatus,
INBTSerializable<CompoundNBT> {
    private final PlayerTraderStandings.IRequestFactoryProvider provider;
    private final PlayerEntity player;
    private float reputation;
    private boolean maxedOutReputation;

    public TraderStatus(PlayerTraderStandings.IRequestFactoryProvider provider, PlayerEntity player) {
        this.provider = provider;
        this.player = player;
    }

    @Override
    public float getReputation() {
        return this.reputation;
    }

    @Override
    public void addReputation(float reputation) {
        ReputationStatus previousStatus = ReputationStatus.getStatus(this.reputation);
        float input = this.reputation + reputation;
        this.reputation = ReputationHelper.clampWithinReputationLimits(input);
        ReputationStatus currentStatus = ReputationStatus.getStatus(this.reputation);
        this.sendReputationStatusUpdate(previousStatus, currentStatus);
        if (!this.maxedOutReputation && ReputationHelper.isMaxedOut(this.reputation)) {
            this.maxedOutReputation = true;
            ReputationHelper.awardPlayerForReputation(this.player);
        }
        this.synchronize();
        GunsRPG.log.debug(QuestSystem.MARKER, "Updated {}'s reputation to {}", (Object)this.player.func_200200_C_().getString(), (Object)Float.valueOf(this.reputation));
    }

    @Override
    public void onTraderAttacked() {
        this.addReputation(-0.5f);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74776_a("reputation", this.reputation);
        nbt.func_74757_a("maxedOutReputation", this.maxedOutReputation);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.reputation = nbt.func_74760_g("reputation");
        this.maxedOutReputation = nbt.func_74767_n("maxedOutReputation");
    }

    private void synchronize() {
        this.provider.getRequestFactory().makeSyncRequest();
    }

    private void sendReputationStatusUpdate(ReputationStatus prev, ReputationStatus current) {
        if (prev == current || this.player.field_70170_p.field_72995_K) {
            return;
        }
        int oldStatusValue = prev.ordinal();
        int statusValue = current.ordinal();
        IFormattableTextComponent status = current.getStatusDescriptor();
        TranslationTextComponent message = new TranslationTextComponent(oldStatusValue < statusValue ? "quest.reputation.upgraded" : "quest.reputation.lost", new Object[]{status});
        this.player.func_145747_a((ITextComponent)message, Util.field_240973_b_);
    }
}

